function z = fxlin(xpts,h,xend)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = fxlin(xpts,h,xend)
% This function  computes values of the linear finite element 
% basis function phi(x) multiplied by a function f(x). 
% It is called by quad in forming the right-hand side for a 
%   finite element problem.
%
% Input:
%  xpts is a row or column vector of points
%  abs(h) is the distance between meshpoints.
%  xend is an endpoint of the interval over which 
%      the basis function is nonzero.
%
% The definition of phi is 
%             phi(x) = (x - xend)/h,
% so if h>0, then xend is the right endpoint of the interval over
% which the basis function is nonzero, and we are looking at the
% interval over which phi is increasing.
% If h < 0, then xend is the left endpoint, and we are looking at the
% interval over which phi is decreasing.
%
% Outputs:
%  z =  f(x) phi(x)
%
% fxlin.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

phi =  (xpts-xend)/h;

z = f(xpts).*phi;
