% This program runs the Volterra model for the
% population of rabbits and foxes and plots the
% results.
% The model is
%    r' = 2 r - alpha r f
%    f' = - f + alpha r f
% with initial conditions r(0) = 20, f(0) = 10.
% The parameter alpha is the encounter factor
% and it is set to 1, 0.1, and 0.01.
% Dianne P. O'Leary  04/2008

global alpha

for i=2:-1:0,
   alpha = 10^(-i)  
	[t,y] = ode45(@rabfox,[0:.1:2], [20,10]);   
	plot(t,y(:,1),'r',t,y(:,2),'b');
   legend('rabbits','foxes')
   title(sprintf('alpha = %f',alpha));
   drawnow
   disp(sprintf('Calculation for alpha=%f completed.',alpha))
   disp('Pausing. Press any key to continue.')
   pause
end
