function [x,y]=ellipse(bs,s)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [x,y] = ellipse(bs,s)
%
% Defines (x/myalpha)^2 + (y/mybeta)^2 = 1, setting up
% the datastructures required by Matlab's finite element
% routines.  These are coordinates (x,y) of points on
% the boundary of the ellipse.
%
% The parameters myalpha and mybeta are passed through 
% global variables.
%
% Dianne O'Leary 02/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global myalpha mybeta 

if nargin==0
  x = 2;
  return
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define two segments in the boundary: 0 to pi, pi to 2pi.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dl = [0 pi
     pi 2*pi
     1   1
     0   0];

if nargin==1
  x = dl(:,bs);
  return
end

x = myalpha*cos(s);
y = mybeta*sqrt(1-(x/myalpha).^2);
ind = find(s>pi);
y(ind) = -y(ind);
