function d = find_dist(lam)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function d = find_dist(lam)
%
% Given a Lagrange multiplier estimate lam, this function
% returns the value
%         (x/myalpha)^2 + (y/mybeta)^2 - 1
% where x and y are functions of lam.
%
% The function is used in dist_to_ellipse, as an argument
% to the zerofinder fzero.
%
% The parameters myalpha, mybeta, and myz are passed 
% through global variables.
%
% Dianne O'Leary 04/2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global myalpha mybeta myz

for i=1:length(lam),

   z0 = [myalpha^2*myz(1)/(myalpha^2-lam(i)),
         mybeta^2*myz(2)/(mybeta^2-lam(i))];

   d(i) = (z0(1)/myalpha)^2 + (z0(2)/mybeta)^2 - 1;

end
