using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace WindowsApplication1 {
	/// <summary>
	/// A simple example to show how a cursor can be made to be blink without
	/// use of a secondary thread.
	/// 
	/// Ben Bederson
	/// University of Maryland
	/// May 2005
	/// </summary>
	public class BlinkingCursorTimer : System.Windows.Forms.Form {
		private System.ComponentModel.Container components = null;
		private bool cursorVisible = false;
		private Timer timer;

		public BlinkingCursorTimer() {
			InitializeComponent();
			timer = new Timer();
			timer.Interval = 500;
			timer.Tick += new EventHandler(timer_Tick);
			timer.Start();
		}

		protected override void OnPaint(PaintEventArgs e) {
			base.OnPaint (e);

			if (cursorVisible) {
				e.Graphics.DrawLine(Pens.Red, 10, 10, 10, 100);
			}
		}

		protected override void Dispose( bool disposing ) {
			if( disposing ) {
				if (components != null) {
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			this.components = new System.ComponentModel.Container();
			this.Size = new System.Drawing.Size(300,300);
			this.Text = "Form1";
		}
		#endregion

		[STAThread]
		static void Main() {
			Application.Run(new BlinkingCursorTimer());
		}

		private void timer_Tick(object sender, EventArgs e) {
			cursorVisible = !cursorVisible;
			Invalidate();
		}
	}
}