#ifndef EOBJECT_H
#define EOBJECT_H
#include <GL/glut.h>
#include <vector>
#include <map>
#include "Triangle.h"
#include "GLPoint.h"
#include "Global.h"
#include "NeighborList.h"

using namespace std;

class CollisionEdge;

class Edge
{
public:
   static enum states { None, Processing, Done };

	GLPoint *p1;
	GLPoint *p2;

   states state;
	bool outerEdge;   // Decides if the edge is part of a "real edge" of the polygon or just part of a triangle
   bool operator==( const CollisionEdge & ); // NEW
   bool operator==( const Edge & ); // NEW
};

// NEW - struct was converted to a class
class CollisionEdge
{
public:
	GLPoint* point[2];
	int collisionIdx;
   
   bool operator==( const CollisionEdge& ); // NEW
   bool operator==( const Edge& ); // NEW
   bool interior;  // NEW
};


class EObject
{
public:
	vector<GLPoint> vertex;
	vector<GLPoint> oldPos;
	vector<Triangle *> face;
	vector<NeighborList *> depend;
	material mat;
	vector<Vector> velocity, oldVel;
	vector<Vector> acceleration;
	vector<Vector> force_external;
	vector<Vector> force_internal;

	
	GLPoint center;
	vector<float> distToCenter;

	float k;   // is in range around 1 to 50 (smaller is more elastic)
	float mass;
   float cdRadius;

  	bool draw_force;

	int esize, estart;
	Edge *edges;	
   
   Vector gravity;

	EObject (string fileIn);
	float edge (GLPoint p1, GLPoint p2);

   vector<Vector> dep1;
	vector<Vector> dep2;
   vector<Vector> dep3;

   float avgDist;
   int numEdge;
	void readFromFile (string fname);
	void addPoint (GLPoint p, Vector vel);
   void addEdge( int p1, int p2 );
   bool EdgeExists(Edge e);
   
	void addFace (int p1, int p2, int p3);
	void setVelocity (int i, Vector v);
	void setExAcceleration (int i, Vector v);
   void buildDone ();

	void draw();
	void update();

   void Draw();
	void Update();
   GLPoint getPosition() const;
   void setPosition( GLPoint &p );
   float getCDRadius() const;
   float getFixed () const;
      
   bool CollisionDetected( EObject &o, vector<CollisionEdge> &collisionEdges, 
                                 vector<GLPoint> &collisionPoints ) const;
   void DFSRec( GLPoint &p, vector<GLPoint> &collisionPoints );
   void DFS(vector<CollisionEdge> &collisionEdges, vector<GLPoint> &collisionPoints);

	~EObject ();
};

#endif;