#ifndef GLPOINT_H
#define GLPOINT_H
#include "Vector.h"
#include "Math.h"

class GLPoint
{
public:
	GLPoint()
	{ this->x = 0; this->y = 0; this->z = 0; }

	GLPoint( float x, float y, float z )
	{ this->x = x; this->y = y; this->z = z; }
   
   Vector operator-( const GLPoint &p )  const
   {return Vector( x - p.x, y-p.y, z-p.z); }
   
   GLPoint operator+( const GLPoint &p )  const
   {return GLPoint( x + p.x, y+p.y, z+p.z); }
   
   bool operator==( const GLPoint &p )  const
   {return ( x == p.x && y==p.y && z==p.z); }

   float Distance( GLPoint &p ) const
   { return (float)sqrt( pow(x-p.x,2) + pow(y-p.y,2) + pow(z-p.z,2)); }

	
   float x, y, z;
	
};

#endif
