#include "GLWindow.h"

#include "Global.h"
#include "GLPoint.h"
#include "EObject.h"
#include "Time.h"

#include <GL/glut.h>
#include <math.h>

GLWindow* GLWindow::window = NULL;

GLWindow::GLWindow( World *world, string caption )
{
	this->caption = caption;

	top = left = 100;
	height = width = 512;

	this->world = world;
   setInstance();
}


void GLWindow::start(int argc, char **argv )
{
	Time::ResetTimer();

	glutInit( &argc, argv );
	
	glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );

	glutInitWindowSize(height, width);
	glutInitWindowPosition(left, top);

	windowHandle = glutCreateWindow( caption.c_str() );

	glutDisplayFunc(GLWindow::show);
	glutIdleFunc(GLWindow::idleShow);
	glutReshapeFunc(GLWindow::resize); 
	//glutKeyboardFunc(GLWindow::keyboard); 

	world->initWorldProperties();

	glutMainLoop();
}


void GLWindow::close()
{

}

void GLWindow::setInstance()
{
   window = this;
}

void GLWindow::setDimension( int width, int height )
{
	this->height = height;
	this->width = width;
}


void GLWindow::setPosition( int left, int top )
{
	this->left = left;
	this->top = top;
}




void GLWindow::resize(int w, int h)
{
	
	glViewport( 0, 0, w, h );
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
   
	window->width = w;
	window->height = h;

	gluPerspective( 60, (float)window->width / (float)window->height, 2, 20 );
	
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	
   // use the one in show()
	//gluLookAt(2.5,1.5,-5, 2.5,2.5,2.5, 0,1,0);
}


void GLWindow::show()
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	
	gluPerspective( 60, (float)window->width / (float)window->height, 2, 120 );
	
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	
   //gluLookAt(.2,2,.2, 2.5,2.5, 2.5, 0,1,0);
	//gluLookAt(2.5,1.5,-5, 2.5,2.5,2.5, 0,1,0);
   
   //gluLookAt(2,1.5,-10, 10,10,10, 0,1,0);
	
	gluLookAt(2,1.,-3, 10,3,5, 0,1,0);
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
   window->world->DrawWorld();

	glutSwapBuffers();
}


void GLWindow::idleShow()
{
   window->world->DoWork();

	glutPostRedisplay();
}

