#ifndef Vector_H
#define Vector_H


class Vector
{
public:
	Vector();
	Vector( float x, float y, float z );
   
   Vector operator+( const Vector &v );
   Vector operator-( const Vector &v );
   Vector operator/( float d ) const;
   Vector operator*( float d ) const;
   float operator*( const Vector &v );  // Dot Product
   float operator~() const;
   float Angle( const Vector &v );
   Vector Normalize();
   bool operator== (const Vector &v);   
   bool operator!= (const Vector &v);

   Vector& operator+=( const Vector &v );

   Vector CrossProduct( const Vector &v );

   static Vector ZeroVector;
  
	float x, y, z;
};


#endif
