#include "World.h"
#include "Time.h"
#include "GLWindow.h"
#include <string>
#include <iostream>

double World::time_elapsed = 0;
const float World::ground_level = 0;


World::World(void)
{
   AddGroundAndWalls();
}


void World::AddGroundAndWalls()
{
  
}


World::~World()
{
   //delete ground;
   //delete left_wall;
   //delete back_wall;
   //delete right_wall;
   //delete ceiling;
}

void World::addObject( EObject *obj )
{
   objects.push_back( obj );
}

void World::addGlutSphere(GLPoint p, float radius)
{
   struct Sphere s;
   s.p = p;
   s.radius = radius;
   spheres.push_back(s);
}


void World::setLighting()
{
   float gl_light_pos0[4] = {  0, 30,0, 1 };
   //float gl_light_pos0[4] = {  60, 50, 60, 1 };
   float gl_light_pos1[4] = { 10, -820, -10, 1 };

   glLightfv( GL_LIGHT0, GL_POSITION, gl_light_pos0 );
 
   glLightfv( GL_LIGHT1, GL_POSITION, gl_light_pos1 );

  
   glMatrixMode( GL_PROJECTION );

   glEnable( GL_LIGHTING );
   glEnable( GL_LIGHT0 );
   //glEnable( GL_LIGHT1 );
}

void World::initWorldProperties()
{
   glClearColor( 0.0, 0.0, 0.0, 1.0);

   // Turn on Depth Testing
   glShadeModel( GL_SMOOTH );
   glDepthFunc( GL_LEQUAL );
   glEnable( GL_DEPTH_TEST );
   glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST );


   // And God Said Let There be Light...
   setLighting();

   glMatrixMode( GL_MODELVIEW );
}


void World::DrawWorld()
{
   unsigned int i;

   for( i=0; i < objects.size(); i++ )
   {
      objects[i]->Draw();
   }

   for( i=0; i < spheres.size(); i++ )
   {
      glPushMatrix();
      glMaterialfv( GL_FRONT, GL_DIFFUSE,   Material::red_metal.diff );
      glMaterialfv( GL_FRONT, GL_SPECULAR,  Material::red_metal.spec );
      glMaterialfv( GL_FRONT, GL_AMBIENT,   Material::red_metal.amb );
      glMaterialfv( GL_FRONT, GL_SHININESS, &Material::red_metal.shin );
      glTranslatef(spheres[i].p.x, spheres[i].p.y, spheres[i].p.z);
      glutSolidSphere( spheres[i].radius, 8, 16 );
      glPopMatrix();
   }

   glPushMatrix();
   glMaterialfv( GL_FRONT, GL_DIFFUSE,   Material::yellow_metal.diff );
   glMaterialfv( GL_FRONT, GL_SPECULAR,  Material::yellow_metal.spec );
   glMaterialfv( GL_FRONT, GL_AMBIENT,   Material::yellow_metal.amb );
   glMaterialfv( GL_FRONT, GL_SHININESS, &Material::yellow_metal.shin );
   glBegin(GL_POLYGON);
	glNormal3f(0,1,0);
	glVertex3f(0,0,0);
	glVertex3f(0,0,50);
	glVertex3f(50,0,50);
	glVertex3f(50,0,0);
	
   glEnd();
   glPopMatrix();
}


void World::DoWork()
{
   vector<CollisionEdge> collisionEdgesA, collisionEdgesB;
   vector<GLPoint> collisionPointA, collisionPointB;

   unsigned int i, n;
   float rad, dist;

   if( (time_elapsed = Time::GetTimeElapsedMS()) >= 4 )
   {
      Time::ResetTimer();

      for( i=0; i < objects.size(); i++ )
      {
         objects[i]->Update();
      }

      for( i=0; i < objects.size(); i++ )
         for( n=0; n < objects.size(); n++ )
         {
            GLPoint k = objects[i]->getPosition();
            GLPoint j = objects[n]->getPosition();

            if( i != n && (dist=objects[i]->getPosition().Distance( objects[n]->getPosition() )) <= 
               (rad = objects[i]->getCDRadius() + objects[n]->getCDRadius()) )
            {
               // Do only if one of the objects is not fixed
               if (!objects[i]->getFixed() || !objects[n]->getFixed())
               {

                  if( objects[i]->CollisionDetected( *objects[n], collisionEdgesA, collisionPointB ) ) 
                  {
                     objects[n]->CollisionDetected( *objects[i], collisionEdgesB, collisionPointA );
                     
                     objects[i]->DFS(collisionEdgesA, collisionPointA);
                     objects[n]->DFS(collisionEdgesB, collisionPointB);
                     
                     
                     //This code makes the edges and polygons of intersection visible
                     //on the screen, this is just for debuggging purposes.

                    // cout << collisionPointA.size() << endl;
                    // cout << collisionPointB.size() << endl;

                     int x=0;
                     /*
					 for( x=0; x < collisionPointA.size(); x++ )
                        addGlutSphere(collisionPointA[x] , .2);
                     for( x=0; x < collisionPointB.size(); x++ )
                        addGlutSphere(collisionPointB[x] , .2);
                     */

                     // Collision Response.
                    
                     //cout << "Colided!!! " << (int)collisionPointA.size() << endl;
                     
					 vector<int> pointIndexI, pointIndexII; 
                     
                     for (int pi = 0; pi < (int)objects[i]->vertex.size(); pi++) {
						for( int x=0; x < (int)collisionPointA.size(); x++ ){
							if (collisionPointA[x] == objects[i]->vertex[pi]){ 
                              pointIndexI.push_back(pi);
							  break;
                              //cout <<x << "P: " << pi << endl;                     
                           }
                        }
                     }
					
					 
                     for (int pi = 0; pi < (int)objects[n]->vertex.size(); pi++) {
						for( int x=0; x < (int)collisionPointB.size(); x++ ){
                          if (collisionPointB[x] == objects[n]->vertex[pi]){ 
                              pointIndexII.push_back(pi);
							  break;
                              //cout <<x << "P: " << pi << endl;                     
                           }
                        }
                     }
					 //cout << pointIndexI.size() << " " << pointIndexII.size() << endl;
					 float avgVelIz = 0, avgVelIIz = 0;

					 for (int k = 0; k < (int)pointIndexI.size(); k++) {
						 avgVelIz += objects[i]->velocity[k].z;
						
					 }
					 avgVelIz = avgVelIz/pointIndexI.size();

                     for (int k = 0; k < (int)pointIndexII.size(); k++) {
						 avgVelIIz += objects[n]->velocity[k].z;
					 }

					 avgVelIIz = avgVelIIz/pointIndexII.size();

					 float newVelIz, newVelIIz;

					 newVelIz = - avgVelIz/2;
					 newVelIIz = - avgVelIIz/2;


					 //--------------
					 float avgVelIx = 0, avgVelIIx = 0;

					 for (int k = 0; k < (int)pointIndexI.size(); k++) {
						avgVelIx += objects[i]->velocity[k].x;
					 }
					 avgVelIx = avgVelIx/pointIndexI.size();

                     for (int k = 0; k < (int)pointIndexII.size(); k++) {
						 avgVelIIx += objects[n]->velocity[k].x;
					 }

					 avgVelIIx = avgVelIIx/pointIndexII.size();

					 float newVelIx, newVelIIx;

					 newVelIx = - avgVelIx/2;
					 newVelIIx = - avgVelIIx/2;

					 //-------------------
					 float avgVelIy = 0, avgVelIIy = 0;

					 for (int k = 0; k < (int)pointIndexI.size(); k++) {
						 avgVelIy += objects[i]->velocity[k].y;
					 }
					 avgVelIy = avgVelIy/pointIndexI.size();

                     for (int k = 0; k < (int)pointIndexII.size(); k++) {
						 avgVelIIy += objects[n]->velocity[k].y;
					 }

					 avgVelIIy = avgVelIIy/pointIndexII.size();

					 float newVelIy, newVelIIy;

					 newVelIy =  avgVelIIy;
					 newVelIIy =  avgVelIy;

					 //-----------
					//cout << newVelIx << ", " << newVelIy << ", " << newVelIz << endl;
					//cout << newVelIIx << ", " << newVelIIy << ", " << newVelIIz << endl;
					//cout << "--------------------------" << endl;
					 for (int k = 0; k < (int)pointIndexI.size(); k++) {
						 objects[i]->setVelocity (k,Vector(/*0,0,0*/newVelIx, newVelIy, newVelIz));
						 objects[i]->vertex[k] = objects[i]->oldPos[k];
					 }
                     
					 for (int k = 0; k < (int)pointIndexII.size(); k++) {
						 objects[n]->setVelocity(k,Vector(/*0,0,0*/newVelIIx, newVelIIy, newVelIIz));
						 objects[n]->vertex[k] = objects[n]->oldPos[k];
					 }
                     
				  }
               }
            }
         }
   }
}