#ifndef WORLD_H
#define WORLD_H

#include <vector>
#include "Global.h"
#include "EObject.h"

class World
{
public:
	World(void);
	~World();

	void addObject( EObject *obj );
   void addGlutSphere( GLPoint p, float radius);
   static double getTimeStep() { return time_elapsed; }
   void addLine( GLPoint p1, GLPoint p2 );

	void setLighting();
	void initWorldProperties();
   void DrawWorld();
   void DoWork();
   void AddGroundAndWalls();

   struct Sphere
   {
      GLPoint p;
      float radius;
   };

   vector<EObject *> objects;
   vector<Sphere> spheres;
   
   static const float ground_level;

private:
   static double time_elapsed;
   /*GLObject *left_wall;
   GLObject *back_wall;
   GLObject *right_wall;
   GLObject *ceiling;
   GLObject *ground;*/
};

#endif