function makeplot(n,data,mytitle,myxlabel,myylabel)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function makeplot(n,data,mytitle,myxlabel,myylabel)
% This function plots the data from solution20.m
% Input:
%   n:  array of values for the x coordinate
%   data: array of values for the y coordinate
%   mytitle: string giving the title for the plot
%   myxlabel: string giving the xlabel for the plot
%   myylabel: string giving the ylabel for the plot
%
% Dianne O'Leary 04/2006
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The array mysymb specifies styles for successive curves plotted
% on the following figures.  For example, .b specifies a dotted blue
% line, and  og  specifies a set of green circles.
%
% Similarly, the array legenders contains the legend captions for
% the various methods.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


mysymb='.bogxr+c*mskdbvg^r<c>mpkhb.gorxc+m*ksbdg';
legenders = 'Chol GS CGGS  cut=.05cut=.5';

[nn,nmethods] = size(data);

figure
for k=[1,3:nmethods]        % Plot the symbols.  (Skip the GS plot.)
  loglog(n,data(:,k),mysymb(2*k+1:2*(k+1)))
  hold on
end
xlabel(myxlabel)
ylabel(myylabel)
legend(legenders(1:5),legenders(9:14),...
       legenders(15:21),legenders(22:27))
title(mytitle)
for k=[1,3:nmethods]        % Plot the lines.  (Skip the GS plot.)
  loglog(n,data(:,k),mysymb(2*k+2))
  hold on
end
hold off

drawnow
