// badmemory.c: illustrates some types of errors that Valgrind can
// catch and others that it cannot.
//
// > gcc -g badmemory.c    # compile with debugging enabled
// > valgrind ./a.out      # run under valgrind, more info on errors
#include <stdio.h>
#include <stdlib.h>
int main(int argc, char **argv){
  int i,j;
  int k = i + j;
  printf("Uninitialized memory\n");
  if(k < 200){
    printf("%d\n",k);             // Caught 
  }                               // valgrind checks uninitialized
  
  printf("Out of bounds on heap\n");
  int *ptr = malloc(sizeof(int)*4);
  for(i=0; i <= 4; i++){
    ptr[i] = i*i;                 // Caught
    printf("%d\n",ptr[i]);        // valgrind checks heap
  }

  printf("Out of bounds on stack\n");
  int a[4];                       // stack-array
  for(i=0; i<=8; i++){
    a[i] = i;
    printf("%d\n",a[i]);          // Not caught
  }                               // stack data is not checked

  printf("About to go WAY out of bounds...\n");
  int *ip = NULL;
  printf("ip has val %p\n", ip);
  printf("Deref *ip: %d\n",*ip);  // Cause a crash

  return 0;
}
