// int_float_arithmetic.c: Demonstrate peculiarities with integer
// versus floating point arithmetic. When right-hand-side computations
// all involve integers, then the instructinos generated are all
// integer operations subject to a quotient and remainder in
// division. This can yield unexpected results in some cases which
// requires care. When in doubt, cast operands or use floating point
// constants as shown.
#include <stdio.h>

int main(){
  int q = 9 / 4;                // quotient 2                       
  int r = 9 % 4;                // remainder 1                      
  double x = 9 / 4;             // 2.0 (int quotient first)         
  double y = (double) 9 / 4;    // 2.25                             
  double z = ((double)9) / 4;   // 2.25                             
  double w = 9.0 / 4;           // 2.25                             
  double t = 9 / 4.0;           // 2.25                             
  int a=9, b=4;                                                     
  double u = a / b;             // 2 (int quotient)

  printf("q: %d\n",q);  // q: 2       
  printf("r: %d\n",r);  // r: 1       
  printf("x: %f\n",x);  // x: 2.000000
  printf("y: %f\n",y);  // y: 2.250000
  printf("z: %f\n",z);  // z: 2.250000
  printf("w: %f\n",w);  // w: 2.250000
  printf("t: %f\n",t);  // t: 2.250000
  printf("u: %f\n",u);  // u: 2.000000

  return 0;
}  
