// pointer_v_array.c: Demonstrate equivalence of pointers and
// arrays. An array is represented by its starting address so can be
// passed to a function taking a pointer as such. Similarly, a pointer
// value is an address so can be passed to a function taking an array
// argument. printf("%p") prints pointer values in hexadecimal format.

#include <stdio.h>

void print0_arr(int a[]){       // print 0th element of a
  printf("%p: %d\n", a, a[0]);  // address and 0th elem
}
void print0_ptr(int *p){        // print int pointed at by p
  printf("%p: %d\n", p, *p);    // address and 0th elem
}
int main(){
  int *p = NULL;                // declare a pointer, points nowhere
  printf("%p: %p\n", &p, p);    // print address/contents of p
  int x = 21;                   // declare an integer
  p = &x;                       // point p at x
  print0_arr(p);                // pointer as array
  int a[] = {5,10,15};          // declare array, auto size
  print0_ptr(a);                // array as pointer
  //a = p;                      // can't change where array points
  p = a;                        // point p at a
  print0_ptr(p);
  return 0;
}
