// sizeof_arrays.c: demonstrations that the sizeof(..) operator
// calculates sizes in BYTES at COMPILE time. It has no knowledge of
// runtime sizes.
#include <stdio.h>
#include <stdlib.h>

int main(){

  int arr[10];
  printf("sizeof(arr):  %d\n",sizeof(arr));

  int *iptr = malloc(sizeof(int)*10);
  printf("sizeof(iptr): %d\n",sizeof(iptr));

  double *dptr = malloc(sizeof(double)*10);
  printf("sizeof(dptr): %d\n",sizeof(dptr));

  free(iptr);
  free(dptr);

  return 0;
}

// DEMO:
// >> gcc sizeof_arrays.c
// >> ./a.out
// sizeof(arr):  40
// sizeof(iptr): 8
// sizeof(dptr): 8
