// void_pointer_hex.c: shows the values for some byte locations in
// void_pointer.c as hexadecimal values to help contstruct memory diagrams. 
#include <stdio.h>
int main(){
  int a = 5;                    // int
  double x = 1.2345;            // double
  void *ptr;                    // pointer to anything

  ptr = &a;
  int b = *((int *) ptr);       // caste to convince compiler to deref
  printf("%d\n",b);

  ptr = &x;
  double y = *((double *) ptr); // caste to convince compiler to deref
  printf("%f\n",y);

  int c = *((int *) ptr);       // kids: this is why types are useful
  printf("%d\n",c);

  char *bytes = (char *) ptr;
  for(int i=7; i>=0; i--){
    printf("%02hhx\n", bytes[i]);
  }
  printf("\n");
  printf("%08x %08x\n",c, *((int *) ptr+1));

  int lo4 = 0x126e978d;
  int hi4 = 0x3ff3c083;

  printf("%d %d\n",lo4,hi4);

  printf("%08x\n",2028);

  return 0;
}
