#include <stdio.h>
#include <math.h>   // macros for infinity
#include <stdlib.h>

void showbits(void *xp);

int main(int argc, char *argv[]){
  if(argc < 2){
    printf("usage: %s <float>\n",argv[0]);
    printf("  prints <float> in several formats\n");
    return 1;
  }
  float fl = atof(argv[1]);     // convert string to float

  printf("entered: %.6f\n",fl);
  printf("exactly: %.20e\n",fl);

  printf("bits:\n");
  showbits((int *) &fl);
  return 0;
}

#define INT_BITS 32

/* Print the most signficant (right-most) to least signficant bit in
   the integer passed in */
void showbits(void *xp){
  int x = *((int *) xp);
  int mask = 0x1;
  for(int i=INT_BITS-1; i>=0; i--){
    int shifted_mask = mask << i;
    if(shifted_mask & x){
      printf("1");
    } else {
      printf("0");
    }
  }
  printf("\n");
}
