// union.c: Shows use of a union to manipulate a memory area as an int
// OR as a float. Shows both typedef'd unions and one-off unions.

#include <stdio.h>
#include <string.h>

// Define a union which overlays bytes
typedef union {                 // shared memory between
  float fl;                     // an float (4 bytes) 
  int in;                       // a int (4 bytes)
  char ch[4];                   // char array (4 bytes)
} flint_t;                      // total size: 4 bytes   

int main(){
  printf("Typedef'd unions\n");

  flint_t flint;                // 4 bytes, treat as either int or float
  flint.in = 0xC378C000;        // assign an int value
  printf("%.4f\n",flint.fl);    // print as a float value
  printf("%d\n",flint.in);      // print as a int value in decimal
  printf("0x%08x\n",flint.in);  // print as a int value in hexadecimal
  for(int i=0; i<4; i++){       // print chars individually
    unsigned char c = flint.ch[i];
    printf("%d: %02x '%c'\n", i,c,c);
  }

  printf("\n");
  printf("One-off unions\n");

  union {                       // a one-off union
    int i;                      // parts of the union
    float f;
    char s[4];                
  } oneoff;                     // variable name of union

  strcpy(oneoff.s,"Bit");       // set the char values

  printf("%e\n",oneoff.f);      // print as a float value
  printf("%d\n",oneoff.i);      // print as a int value in decimal
  printf("0x%08x\n",oneoff.i);  // print as a int value in hex
  for(int i=0; i<4; i++){       // print chars individually
    char c = oneoff.s[i];
    printf("%d: %02x '%c'\n", i,c,c);
  }

  return 0;
}
