// setday_main2.c: a sample main() that calls setday()
#include <stdio.h>
#include <stdlib.h>

// global: days since 1/1/1970
extern int DAYS_SINCE_1970;

// struct containing date info
typedef struct {
  int day;  int year;
} yearday_t;
// Layout of yearday_t in memory and 
// as a packed register argument.
// 
// |       | Byte |   Byte | Packed |
// | Field | Size | Offset |   Bits |
// |-------+------+--------+--------|
// | day   | 4    |     +0 |   0-31 |
// | year  | 4    |     +4 |  32-63 |

int setday(yearday_t yd);

int main(int argc, char *argv[]){
  yearday_t yd2 = 
    { .day = 3, .year = 1972 };
  int ret = setday(yd2);
  printf("%3d days since 1970 (ret: %d)\n",
         DAYS_SINCE_1970, ret);
  // 733 days since 1970 (ret: 0)

  return 0;
}
