### SOLUTION for setday_main2_asm.s ###
.data
FORMAT:
        .string "%3d days since 1970 (ret: %d)\n"

.text
.global main
main:
        subq    $8,%rsp         # grow the stack + align for function calls

        ## 2 METHODS to pack yearday_t struct into register rdi

        ## Method 1: place values in stack space, copy stack
        ## values into arg1 register
        movl    $3,0(%rsp)      # .day = 3
        movl    $1972,4(%rsp)   # .year = 1972
        movq    0(%rsp),%rdi

        ## ## Method 2: struct does not need to be in the stack for any
        ## ## reason so just directly pack the register. NOTE: cannot
        ## ## avoid extending the stack via subq $8,%rsp as rsp must be
        ## ## aligned to a 16-byte boundary for the function calls.
        ## movq    $1972,%rdi
        ## salq    $32,%rdi        # upper 32 bits are .year
        ## orq     $3,%rdi         # lower 32 bits are .day

        call    setday

        movl    %eax,%edx                  # 3rd arg to printf: return value of setday
        movl    DAYS_SINCE_1970(%rip),%esi # 2nd arg to printf (global var)
        leaq    FORMAT(%rip),%rdi          # 1st arg to printf: format string address
        movl    $0,%eax                    # requirement for printf and other var-arg functions
        call    printf@PLT

        addq    $8,%rsp         # restore the stack and return
        movl    $0,%eax
        ret
